/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package pong;

import com.sun.glass.events.KeyEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.Timer;

/**
 *
 * @author Student
 */
public class IcePong extends javax.swing.JFrame {

    private BallThread ballT;
    private AIThread aiT;
    private Timer timer;
    private int pressed = 0;

    /**
     * Creates new form IcePong
     */
    public IcePong() {
        initComponents();

        ballT = new BallThread(lblBall, resultAI, resultUser, lblComputerPad, lblUserPad);
        ballT.start();

        aiT = new AIThread(lblComputerPad, lblBall);
        aiT.start();

        timer = new Timer(10, new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                switch (pressed) {
                    case KeyEvent.VK_UP:
                        lblUserPad.setLocation(lblUserPad.getX(), lblUserPad.getY() - 8);
                        break;
                    case KeyEvent.VK_DOWN:
                        lblUserPad.setLocation(lblUserPad.getX(), lblUserPad.getY() + 8);
                        break;
                }

                if (lblUserPad.getY() < 0 - lblUserPad.getHeight()) {
                    lblUserPad.setLocation(lblUserPad.getX(), 570);
                }
                if (lblUserPad.getY() > 570) {
                    lblUserPad.setLocation(lblUserPad.getX(), 0 - lblUserPad.getHeight());
                }
            }
        });

        timer.start();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lblComputerPad = new javax.swing.JLabel();
        lblUserPad = new javax.swing.JLabel();
        lblBall = new javax.swing.JLabel();
        resultAI = new javax.swing.JTextField();
        resultUser = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setAutoRequestFocus(false);
        setBackground(new java.awt.Color(255, 255, 255));
        setMaximumSize(new java.awt.Dimension(800, 600));
        setMinimumSize(new java.awt.Dimension(800, 600));
        setPreferredSize(new java.awt.Dimension(800, 600));
        setResizable(false);
        addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                formKeyPressed(evt);
            }
            public void keyReleased(java.awt.event.KeyEvent evt) {
                formKeyReleased(evt);
            }
        });

        lblComputerPad.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pong/pad.png"))); // NOI18N

        lblUserPad.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pong/pad.png"))); // NOI18N

        lblBall.setBackground(new java.awt.Color(255, 255, 255));
        lblBall.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pong/ball.png"))); // NOI18N

        resultAI.setText("0");
        resultAI.setFocusable(false);

        resultUser.setText("0");
        resultUser.setFocusable(false);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(resultAI)
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(lblComputerPad)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 387, Short.MAX_VALUE)
                .addComponent(lblBall)
                .addGap(126, 126, 126)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(lblUserPad)
                        .addContainerGap())
                    .addComponent(resultUser)))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(resultAI, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(resultUser, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(140, 140, 140)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblBall)
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(lblComputerPad)
                        .addComponent(lblUserPad)))
                .addContainerGap(104, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_formKeyPressed

        /*if(lblUserPad.getY()<0){
            lblUserPad.setLocation(lblUserPad.getX(),0);
        }
        if(lblUserPad.getY()+lblUserPad.getHeight()>570){
            lblUserPad.setLocation(lblUserPad.getX(),570-lblUserPad.getHeight());
        }*/
        pressed = evt.getKeyCode();
    }//GEN-LAST:event_formKeyPressed

    private void formKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_formKeyReleased
        pressed = 0;
    }//GEN-LAST:event_formKeyReleased

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(IcePong.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(IcePong.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(IcePong.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(IcePong.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new IcePong().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel lblBall;
    private javax.swing.JLabel lblComputerPad;
    private javax.swing.JLabel lblUserPad;
    private javax.swing.JTextField resultAI;
    private javax.swing.JTextField resultUser;
    // End of variables declaration//GEN-END:variables
}

class BallThread extends Thread {

    JTextField resultAI;
    JTextField resultUser;
    JLabel computerPad;
    JLabel userPad;
    JLabel ball;
    int speed = 20;
    int angle = 60;

    BallThread(JLabel ball, JTextField resultAI, JTextField resultUser, JLabel computerPad, JLabel userPad) {
        this.ball = ball;
        this.resultAI = resultAI;
        this.resultUser = resultUser;
        this.computerPad = computerPad;
        this.userPad = userPad;
    }

    @Override
    public void run() {
        boolean recentlyKicked = false;
        boolean recentlyKickedY = false;
        while (true) {
            //recentlyKicked = false;
            if(this.ball.getX()>this.computerPad.getX()+this.computerPad.getWidth()
                    &&
               this.ball.getX()+this.ball.getWidth() < this.userPad.getX()
                    &&
               this.ball.getY() > 0
                    &&
               this.ball.getY()+this.ball.getHeight() < 570)
            {
                recentlyKicked = false;
                recentlyKickedY = false;
            }
            double scale_X = Math.sin(Math.toRadians(angle));
            double scale_Y = Math.cos(Math.toRadians(angle));
            double velocityX = (this.speed * scale_X);
            double velocityY = (this.speed * scale_Y);
            this.ball.setLocation(this.ball.getX() + (int) velocityX, this.ball.getY() + (int) velocityY);
            try {
                this.sleep(30);
            } catch (InterruptedException ex) {
            }

            if (this.ball.getX() < this.computerPad.getX() + this.computerPad.getWidth()
                    && this.ball.getY() + this.ball.getHeight() > this.computerPad.getY()
                    && this.ball.getY() < this.computerPad.getY() + this.computerPad.getHeight()) {
                if(!recentlyKicked) this.angle = 360 - this.angle;
                recentlyKicked = true;
                continue;
            }

            if (this.ball.getX() + this.ball.getWidth() > this.userPad.getX()
                    && this.ball.getY() + this.ball.getHeight() > this.userPad.getY()
                    && this.ball.getY() < this.userPad.getY() + this.userPad.getHeight()) {
                if(!recentlyKicked) this.angle = 360 - this.angle;
                recentlyKicked = true;
                continue;
            }

            if (this.ball.getX() < 0) {
                int currentScore = Integer.parseInt(this.resultUser.getText());
                currentScore++;
                this.resultUser.setText("" + currentScore);
                if(!recentlyKicked) this.angle = 360 - this.angle;
                System.out.println(this.angle);
                recentlyKicked = true;
            }
            if (this.ball.getX() > 800 - this.ball.getWidth()) {
                int currentScore = Integer.parseInt(this.resultAI.getText());
                currentScore++;
                this.resultAI.setText("" + currentScore);
                if(!recentlyKicked) this.angle = 360 - this.angle;
                recentlyKicked = true;
            }
            if (this.ball.getY() < 0) {
                if(!recentlyKickedY) this.angle = 180 - this.angle;
                recentlyKickedY = true;
            }
            if (this.ball.getY() > 570 - this.ball.getHeight()) {
                if(!recentlyKickedY) this.angle = 180 - this.angle;
                recentlyKickedY = true;
            }
        }
    }
}

class AIThread extends Thread {

    JLabel computerPad;
    JLabel ball;

    AIThread(JLabel computerPad, JLabel ball) {
        this.computerPad = computerPad;
        this.ball = ball;
    }

    @Override
    public void run() {
        while (true) {
            if (this.ball.getY() < this.computerPad.getY()) {
                this.computerPad.setLocation(this.computerPad.getX(), this.computerPad.getY() - 8);
            } else if (this.ball.getY() + this.ball.getHeight() > this.computerPad.getY() + this.computerPad.getHeight()) {
                this.computerPad.setLocation(this.computerPad.getX(), this.computerPad.getY() + 8);
            }
            if (computerPad.getY() < 0 - computerPad.getHeight()) {
                computerPad.setLocation(computerPad.getX(), 570);
            }
            if (computerPad.getY() > 570) {
                computerPad.setLocation(computerPad.getX(), 0 - computerPad.getHeight());
            }

            try {
                this.sleep(30);
            } catch (InterruptedException ex) {
                Logger.getLogger(AIThread.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}
