import java.io.*;
import java.util.*;

public class Kontrolno1_var2{
  public static void main(String[] args){
    Movie[] list = new Movie[3];
    try{
      list[0] = new Movie("ZZZ 1", 15000, new FileInputStream("ZAD1.docx"));
      list[1] = new Movie("Test 2", 5000, new FileInputStream("ZAD2.docx"));
      list[2] = new Movie("Test 3", 5000, new FileInputStream("ZAD3.docx"));
    }
    catch(Exception e){
      System.err.println(e.getMessage());
    }
    
    for(int i=0; i<list.length; i++){
      for(int j=i+1; j<list.length; j++){
        try{
          if(Movie.equalTrailers(list[i].trailer, list[j].trailer)){
            System.out.println(list[i].name +" and "+list[j].name+ " are equal");
          }
        }
        catch(IOException e){
          System.err.println(e.getMessage());
        }
      }
    }
    
    Comparator<Movie> cmp = new Comparator<Movie>(){ 
      public int compare(Movie m1, Movie m2) {
        //   -1  m1   m2, 0     1  m2   m1
        int lengthsComparison = Movie.compareMovieLengths(m1, m2);
        if(lengthsComparison!=0) return lengthsComparison;
        else return m1.name.compareTo(m2.name);
      }
    };
    Arrays.sort(list, cmp);
    
    for(Movie m: list){
      System.out.println(m.name);
    }
    
  }
}

class Movie{
  String name;
  private int length;
  FileInputStream trailer;
  
  public Movie(String name, int length, FileInputStream trailer) throws Exception{
    this.name = name;
    this.setLength(length);
    this.trailer = trailer;
  }
  
  int getLength(){
    return this.length;
  }
  
  void setLength(int length) throws Exception{
    if(length<3600) throw new Exception("Movie is too short");
    else this.length = length;
  }
  
  static boolean equalTrailers(FileInputStream m1, FileInputStream m2) throws IOException{
    if(m1.equals(m2)) return true;
    BufferedInputStream input1 = new BufferedInputStream(m1);
    BufferedInputStream input2 = new BufferedInputStream(m2);
    int ch1=-1, ch2=-1;
    while ((ch1 = input1.read())!=-1){
      ch2 = input2.read();
      if (ch1 != ch2) return false;
    }
    return true;
  }
  
  static int compareMovieLengths(Movie m1, Movie m2){
    if(m1.getLength() > m2.getLength()) return -1;
    if(m1.getLength() < m2.getLength()) return 1;
    return 0;
  }
  
  int compareWith(Movie m){
    return Movie.compareMovieLengths(this, m);
  }
}

class LongMovie extends Movie{
  
  public LongMovie(String name, int length, FileInputStream trailer) throws Exception{
    super(name, length, trailer);
    this.setLength(length);
  }
  
  void setLength(int length) throws Exception{
    if(length<10800 ) throw new Exception("This is not a long movie");
    else super.setLength(length);
  }
}